/*
 * Decompiled with CFR 0.152.
 */
package com.moulberry.axiom.scaling;

import com.google.common.math.DoubleMath;
import com.moulberry.axiom.collections.Position2ObjectMap;
import com.moulberry.axiom.collections.PositionSet;
import com.moulberry.axiom.render.regions.ChunkedBlockRegion;
import com.moulberry.axiom.scaling.Scale3x;
import java.math.RoundingMode;
import net.minecraft.class_2246;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class RotSprite {
    public static ChunkedBlockRegion rotate(ChunkedBlockRegion in, float rotationX, float rotationY, float rotationZ) {
        ChunkedBlockRegion scaled = Scale3x.scale3x(in, false);
        Matrix4f matrix4f = new Matrix4f();
        matrix4f.rotateYXZ(rotationY, rotationX, rotationZ);
        return RotSprite.rotateCached(scaled, matrix4f);
    }

    public static ChunkedBlockRegion rotateCached(ChunkedBlockRegion scaled, Matrix4f matrix4f) {
        return RotSprite.rotateCachedWithOutput(scaled, matrix4f, new ChunkedBlockRegion(), 0, 0, 0);
    }

    public static ChunkedBlockRegion rotateCachedWithOutput(ChunkedBlockRegion scaled, Matrix4f matrix4f, ChunkedBlockRegion out, int outputX, int outputY, int outputZ) {
        if (scaled.isEmpty()) {
            return out;
        }
        int minX = scaled.min().method_10263() / 3;
        int minY = scaled.min().method_10264() / 3;
        int minZ = scaled.min().method_10260() / 3;
        int maxX = scaled.max().method_10263() / 3;
        int maxY = scaled.max().method_10264() / 3;
        int maxZ = scaled.max().method_10260() / 3;
        int newMinX = Integer.MAX_VALUE;
        int newMinY = Integer.MAX_VALUE;
        int newMinZ = Integer.MAX_VALUE;
        int newMaxX = Integer.MIN_VALUE;
        int newMaxY = Integer.MIN_VALUE;
        int newMaxZ = Integer.MIN_VALUE;
        Vector4f vector4f = new Vector4f();
        int x2 = minX;
        while (x2 <= maxX) {
            int y2 = minY;
            while (y2 <= maxY) {
                int z2 = minZ;
                while (z2 <= maxZ) {
                    vector4f.set((float)x2, (float)y2, (float)z2, 1.0f);
                    matrix4f.transform(vector4f);
                    newMinX = Math.min(newMinX, (int)Math.floor(vector4f.x));
                    newMinY = Math.min(newMinY, (int)Math.floor(vector4f.y));
                    newMinZ = Math.min(newMinZ, (int)Math.floor(vector4f.z));
                    newMaxX = Math.max(newMaxX, (int)Math.ceil(vector4f.x));
                    newMaxY = Math.max(newMaxY, (int)Math.ceil(vector4f.y));
                    newMaxZ = Math.max(newMaxZ, (int)Math.ceil(vector4f.z));
                    if (z2 == maxZ) break;
                    z2 = maxZ;
                }
                if (y2 == maxY) break;
                y2 = maxY;
            }
            if (x2 == maxX) break;
            x2 = maxX;
        }
        Matrix4f inverted = matrix4f.invert(new Matrix4f());
        Quaternionf dest = new Quaternionf();
        matrix4f.getNormalizedRotation(dest);
        Vector3f euler = dest.getEulerAnglesYXZ(new Vector3f());
        int rotationCount = Math.round((float)Math.toDegrees(euler.y) / 90.0f);
        if ((rotationCount %= 4) < 0) {
            rotationCount += 4;
        }
        class_2470 rotation = switch (rotationCount) {
            default -> class_2470.field_11467;
            case 1 -> class_2470.field_11465;
            case 2 -> class_2470.field_11464;
            case 3 -> class_2470.field_11463;
        };
        PositionSet filled = new PositionSet();
        for (int x3 = newMinX; x3 <= newMaxX; ++x3) {
            for (int y3 = newMinY; y3 <= newMaxY; ++y3) {
                for (int z3 = newMinZ; z3 <= newMaxZ; ++z3) {
                    vector4f.set((float)x3, (float)y3, (float)z3, 1.0f);
                    inverted.transform(vector4f);
                    int sampleX = DoubleMath.roundToInt((double)(vector4f.x * 3.0f + 1.0f), (RoundingMode)RoundingMode.HALF_DOWN);
                    int sampleY = DoubleMath.roundToInt((double)(vector4f.y * 3.0f + 1.0f), (RoundingMode)RoundingMode.HALF_DOWN);
                    int sampleZ = DoubleMath.roundToInt((double)(vector4f.z * 3.0f + 1.0f), (RoundingMode)RoundingMode.HALF_DOWN);
                    class_2680 blockState = scaled.getBlockStateOrAir(sampleX, sampleY, sampleZ);
                    if (blockState.method_26215()) continue;
                    out.addBlockWithoutDirty(x3 + outputX, y3 + outputY, z3 + outputZ, blockState.method_26186(rotation));
                    filled.add(x3, y3, z3);
                }
            }
        }
        class_2680 air = class_2246.field_10124.method_9564();
        Position2ObjectMap<class_2680> additionalBlocks = new Position2ObjectMap<class_2680>(k -> new class_2680[4096]);
        for (int x4 = newMinX; x4 <= newMaxX; ++x4) {
            for (int y4 = newMinY; y4 <= newMaxY; ++y4) {
                block13: for (int z4 = newMinZ; z4 <= newMaxZ; ++z4) {
                    if (!out.getBlockStateOrAir(x4 + outputX, y4 + outputY, z4 + outputZ).method_26215()) continue;
                    vector4f.set((float)x4, (float)y4, (float)z4, 1.0f);
                    inverted.transform(vector4f);
                    int sampleX = DoubleMath.roundToInt((double)(vector4f.x * 3.0f + 1.0f), (RoundingMode)RoundingMode.HALF_DOWN);
                    int sampleY = DoubleMath.roundToInt((double)(vector4f.y * 3.0f + 1.0f), (RoundingMode)RoundingMode.HALF_DOWN);
                    int sampleZ = DoubleMath.roundToInt((double)(vector4f.z * 3.0f + 1.0f), (RoundingMode)RoundingMode.HALF_DOWN);
                    for (int xo = -1; xo <= 1; ++xo) {
                        for (int yo = -1; yo <= 1; ++yo) {
                            for (int zo = -1; zo <= 1; ++zo) {
                                class_2680 block2;
                                if (xo == 0 && yo == 0 && zo == 0 || filled.contains(x4 + xo, y4 + yo, z4 + zo)) continue;
                                int sum = Math.abs(xo) + Math.abs(yo) + Math.abs(zo);
                                if (sum == 2) {
                                    if (xo == 0) {
                                        if (filled.contains(x4, y4 + yo, z4) || filled.contains(x4, y4, z4 + zo)) {
                                            continue;
                                        }
                                    } else if (yo != 0 ? filled.contains(x4 + xo, y4, z4) || filled.contains(x4, y4 + yo, z4) : filled.contains(x4 + xo, y4, z4) || filled.contains(x4, y4, z4 + zo)) continue;
                                }
                                if (sum == 3) continue;
                                vector4f.set((float)(x4 + xo), (float)(y4 + yo), (float)(z4 + zo), 1.0f);
                                inverted.transform(vector4f);
                                int sampleX2 = DoubleMath.roundToInt((double)(vector4f.x * 3.0f + 1.0f), (RoundingMode)RoundingMode.HALF_DOWN);
                                int sampleY2 = DoubleMath.roundToInt((double)(vector4f.y * 3.0f + 1.0f), (RoundingMode)RoundingMode.HALF_DOWN);
                                int sampleZ2 = DoubleMath.roundToInt((double)(vector4f.z * 3.0f + 1.0f), (RoundingMode)RoundingMode.HALF_DOWN);
                                int offsetX = sampleX2 > sampleX ? 1 : -1;
                                int offsetY = sampleY2 > sampleY ? 1 : -1;
                                int offsetZ = sampleZ2 > sampleZ ? 1 : -1;
                                class_2680 class_26802 = block2 = sampleX == sampleX2 ? air : scaled.getBlockStateOrAir(sampleX + offsetX, sampleY, sampleZ);
                                if (block2.method_26215()) {
                                    class_2680 class_26803 = block2 = sampleY == sampleY2 ? air : scaled.getBlockStateOrAir(sampleX, sampleY + offsetY, sampleZ);
                                }
                                if (block2.method_26215()) {
                                    class_2680 class_26804 = block2 = sampleZ == sampleZ2 ? air : scaled.getBlockStateOrAir(sampleX, sampleY, sampleZ + offsetZ);
                                }
                                if (block2.method_26215()) continue;
                                if (sampleX != sampleX2 && !scaled.getBlockStateOrAir(sampleX2 - offsetX, sampleY2, sampleZ2).method_26215()) {
                                    additionalBlocks.put(x4, y4, z4, block2);
                                    continue block13;
                                }
                                if (sampleY != sampleY2 && !scaled.getBlockStateOrAir(sampleX2, sampleY2 - offsetY, sampleZ2).method_26215()) {
                                    additionalBlocks.put(x4, y4, z4, block2);
                                    continue block13;
                                }
                                if (sampleZ == sampleZ2 || scaled.getBlockStateOrAir(sampleX2, sampleY2, sampleZ2 - offsetZ).method_26215()) continue;
                                additionalBlocks.put(x4, y4, z4, block2);
                                continue block13;
                            }
                        }
                    }
                }
            }
        }
        additionalBlocks.forEachEntry((x, y, z, block) -> {
            if (RotSprite.shouldUseAdditional(x, y, z, additionalBlocks, filled)) {
                out.addBlockWithoutDirty(x + outputX, y + outputY, z + outputZ, block.method_26186(rotation));
            }
        });
        out.dirtyAll();
        return out;
    }

    private static boolean shouldUseAdditional(int x, int y, int z, Position2ObjectMap<class_2680> additionalBlocks, PositionSet filled) {
        int neighbors = 0;
        if (additionalBlocks.get(x + 1, y, z) != null) {
            ++neighbors;
        }
        if (additionalBlocks.get(x - 1, y, z) != null) {
            ++neighbors;
        }
        if (additionalBlocks.get(x, y + 1, z) != null) {
            ++neighbors;
        }
        if (additionalBlocks.get(x, y - 1, z) != null) {
            ++neighbors;
        }
        if (additionalBlocks.get(x, y, z + 1) != null) {
            ++neighbors;
        }
        if (additionalBlocks.get(x, y, z - 1) != null) {
            ++neighbors;
        }
        if (neighbors >= 2) {
            return true;
        }
        boolean plusX = false;
        boolean plusY = false;
        boolean plusZ = false;
        boolean zeroX = false;
        boolean zeroY = false;
        boolean zeroZ = false;
        boolean minusX = false;
        boolean minusY = false;
        boolean minusZ = false;
        for (int xo = -1; xo <= 1; ++xo) {
            for (int yo = -1; yo <= 1; ++yo) {
                for (int zo = -1; zo <= 1; ++zo) {
                    if (xo == 0 && yo == 0 && zo == 0) continue;
                    if (filled.contains(x + xo, y + yo, z + zo)) {
                        if (xo == -1) {
                            minusX = true;
                        }
                        if (yo == -1) {
                            minusY = true;
                        }
                        if (zo == -1) {
                            minusZ = true;
                        }
                        if (xo == 0) {
                            zeroX = true;
                        }
                        if (yo == 0) {
                            zeroY = true;
                        }
                        if (zo == 0) {
                            zeroZ = true;
                        }
                        if (xo == 1) {
                            plusX = true;
                        }
                        if (yo == 1) {
                            plusY = true;
                        }
                        if (zo != 1) continue;
                        plusZ = true;
                        continue;
                    }
                    if (additionalBlocks.get(x + xo, y + yo, z + zo) == null) continue;
                    if (xo == -1) {
                        minusX = true;
                    }
                    if (yo == -1) {
                        minusY = true;
                    }
                    if (zo == -1) {
                        minusZ = true;
                    }
                    if (xo == 1) {
                        plusX = true;
                    }
                    if (yo == 1) {
                        plusY = true;
                    }
                    if (zo != 1) continue;
                    plusZ = true;
                }
            }
        }
        if (plusX && !zeroX && minusX) {
            return true;
        }
        if (plusY && !zeroY && minusY) {
            return true;
        }
        return plusZ && !zeroZ && minusZ;
    }
}

